local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// the items we should sort.
	self.Items = {};
	
	// no spacing
	self.Spacing = 0;
	
end

// add item
function PANEL:AddItem( itm )
	// add item.
	table.insert( self.Items, itm );

end

// padding
function PANEL:SetSpacing( p )
	self.Spacing = p;

end

// perform layout
function PANEL:PerformLayout( )
	// update
	self:Update();

end

// update.
function PANEL:Update( )
	// size the elements
	local ofs = 0;
	local width = self:GetWide();
	
	// fore ach
	local i;
	for i = 1, table.getn( self.Items ) do
		// item
		local item = self.Items[i];
		
		// position it.
		item:SetPos( 0, ofs );
		
		// HACK HACK
		if( item.PerformLayout ) then
			item:PerformLayout();
			
		end
		
		// size it.
		item:SetSize( width, item:GetTall() );
		
		// fetch it's height and increment offset
		ofs = ofs + item:GetTall() + self.Spacing;
	
	end

	// set my height.
	local height = ofs - self.Spacing;
	self:SetSize( width, height );
	
	// reutnr the new height
	return height;
	
end

// draw
function PANEL:Paint( )
	//
	return true;
	
end

// register
vgui.Register( "ctl_listlayout", PANEL, "Panel" );



// create app framework control.
CtlListLayout_class 	= Control_class:create( nil, false, "ctl_listlayout" );

// add item
function CtlListLayout_class:AddItem( item )
	self:GetHandle():AddItem( item:GetHandle() );

end

// set spacing.
function CtlListLayout_class:SetSpacing( d )
	self:GetHandle():SetSpacing( d );

end

// update.
function CtlListLayout_class:Update( )
	return self:GetHandle():Update();

end

